 ; LTR - letter utility - write to a text file from the command line.
 ; (Can interrupt & resume later.)
 ; Copyright 1991, 2000 by Rocket Software
 ; Work on your correspondence from within autocad.
 (DEFUN C:LTR (/ tt ffx fn txt fnp liss)
  (setvar "cmdecho" 0)
  (cond ((= (type fltr) 'str)
         (setq tt (strcat "Filename <" fltr ">: ")))
        ((setq fnp (findfile "acad.ltr"))
         (setq fn (open fnp "r"))
         (setq fltr (read-line fn))
         (close fn)
         (setq tt (strcat "Filename <" fltr ">: ")))
        (T (setq tt "filename: ")))
  (if (/= (setq ffx (getstring tt)) "")
      (setq fltr ffx))
  (if fnp
     (progn
          (setq fn (open fnp "w"))
          (write-line fltr fn)
          (close fn))
     (progn
          (setq fn (open "acad.ltr" "w"))
          (write-line fltr fn)
          (close fn)))
  (if (setq fn (Open fltr "r"))
      (progn
           (while (setq tt (read-line fn))
                  (setq txt tt))
           (Close fn)
           (if txt (write-line (strcat "Last line in file: <" txt ">"))
                   (write-line "Existing (empty) file.")))
      (write-line "New file."))
  (setq fn (Open fltr "a"))
  (while (/= (setq txt (getstring t "Text: ")) "")
         (write-line txt fn))
  (Close fn)
  (setq liss (list
"\nCommand: q"
"\nQSAVE"
"\nCommand: dd"
"\n"
"\n Insertion point: X scale factor <1> / Corner / XYZ:"
"\n Y scale factor (default=X):"
"\n Rotation angle <0.0>:"
"\n"
"\nCommand: z"
"\nZOOM"
"\nAll/Center/Dynamic/Extents/Previous/Scale(X/XP)/Window/<Realtime>: e"
"\nRegenerating drawing."))
  (setq num 0)
  (while (setq str (nth num liss))
         (setq num (1+ num))
         (prompt str))
 (princ))